import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Set up the figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid dimensions
rows, cols = 5, 4
tile_size = 1

# Define colors for clear and occupied tiles
clear_color = 'green'
occupied_color = 'red'
robot_colors = {'robot1': 'white', 'robot2': 'black'}

# Draw the grid and robots
for row in range(rows):
    for col in range(cols):
        tile_id = f"tile_{row}-{col+1}"
        x, y = col * tile_size, (rows - row - 1) * tile_size
        
        # Determine if the tile is occupied or clear
        if (row, col) == (1, 0):
            tile_color = occupied_color
            robot = 'robot1'
        elif (row, col) == (1, 1):
            tile_color = occupied_color
            robot = 'robot2'
        else:
            tile_color = clear_color
            robot = None
        
        # Draw the tile
        ax.add_patch(patches.Rectangle((x, y), tile_size, tile_size, facecolor=tile_color, edgecolor='black'))
        ax.text(x + tile_size / 2, y + tile_size / 2, tile_id, color='white', ha='center', va='center', fontsize=8, fontweight='bold')
        
        # Draw the robot if present
        if robot:
            ax.add_patch(patches.Circle((x + tile_size / 2, y + tile_size / 2), 0.3, facecolor=robot_colors[robot], edgecolor='black'))
            ax.text(x + tile_size / 2, y + tile_size / 2 - 0.4, robot, color='black', ha='center', va='center', fontsize=8, fontweight='bold')

# Create a legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor='white', edgecolor='black', label='Robot holding White'),
    patches.Patch(facecolor='black', edgecolor='black', label='Robot holding Black')
]
ax.legend(handles=legend_elements, loc='upper left', bbox_to_anchor=(1, 1))

# Set limits and aspect
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_47.png', bbox_inches='tight')
plt.show()